﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSFB.Constants;
using AZVIC.Ei8htPOS.POSFB.Controls.Loading;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSFB.Pages
{
    /// <summary>
    /// Interaction logic for PendingQuotations.xaml
    /// </summary>
    public partial class PendingQuotations : Page
    {
        public PendingQuotations()
        {
            InitializeComponent();
            dtStartDate.SelectedDate = dtEndDate.SelectedDate = DateTime.Now;
            LoadPendingQuotations(string.Empty, DateTime.Now, DateTime.Now, 'A');
        }

        private void btnSearch_Click(object sender, RoutedEventArgs e)
        {
            LoadPendingQuotations(txtSearch.Text.Trim(), dtStartDate.SelectedDate != null ? dtStartDate.SelectedDate.Value : DateTime.MinValue,
                dtEndDate.SelectedDate != null ? dtEndDate.SelectedDate.Value : DateTime.MinValue, (chkPOS.IsChecked.Value ? 'P' : (chkWeb.IsChecked.Value ? 'W' : 'A')));
        }

        private void gvPendingQuotation_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            if (sender != null)
            {
                if (gvPendingQuotation != null && gvPendingQuotation.SelectedItems != null && gvPendingQuotation.SelectedItems.Count == 1)
                {
                    DataGridRow dgr = gvPendingQuotation.ItemContainerGenerator.ContainerFromItem(gvPendingQuotation.SelectedItem) as DataGridRow;
                    Quotations currentQuote = dgr.DataContext as Quotations;
                    AppSession.CurrentOrders = ConvertQuoteToPayment(currentQuote);
                    MasterWindow Master = new MasterWindow();
                    Master.LoadPages(new Ordering(), Menus.ORDER);
                }
            }
        }

        private Orders ConvertQuoteToPayment(Quotations currentQuote)
        {
            Orders curOrders = new Orders();
            curOrders.Mode = GlobalConfigurations.Mode.Insert;
            curOrders.OrderFrom = currentQuote.OrderFrom;
            curOrders.UsersAccountID = currentQuote.UsersAccountID;
            curOrders.FirstName = currentQuote.FirstName;
            curOrders.LastName = currentQuote.LastName;
            curOrders.Email = currentQuote.Email;
            curOrders.Company = currentQuote.Company;
            curOrders.BillingAddress1 = currentQuote.BillingAddress1;
            curOrders.BillingAddress2 = currentQuote.BillingAddress2;
            curOrders.BillingCity = currentQuote.BillingCity;
            curOrders.BillingState = currentQuote.BillingState;
            curOrders.BillingCountry = currentQuote.BillingCountry;
            curOrders.BillingPostalCode = currentQuote.BillingPostalCode;
            curOrders.BillingMobile = currentQuote.BillingMobile;
            curOrders.BillingPhone = currentQuote.BillingPhone;
            curOrders.ShippingAddress1 = currentQuote.ShippingAddress1;
            curOrders.ShippingAddress2 = currentQuote.ShippingAddress2;
            curOrders.ShippingCity = currentQuote.ShippingCity;
            curOrders.ShippingState = currentQuote.ShippingState;
            curOrders.ShippingCountry = currentQuote.ShippingCountry;
            curOrders.ShippingPostalCode = currentQuote.ShippingPostalCode;
            curOrders.ShippingMobile = currentQuote.ShippingMobile;
            curOrders.ShippingPhone = currentQuote.ShippingPhone;

            curOrders.IsShipToBillingAddress = currentQuote.IsShipToBillingAddress;
            curOrders.SubTotal = currentQuote.SubTotal;
            curOrders.Discount = currentQuote.Discount;
            curOrders.Shipping = currentQuote.Shipping;
            curOrders.TotalBeforeGST = currentQuote.TotalBeforeGST;
            curOrders.GST = currentQuote.GST;
            curOrders.Total = currentQuote.Total;
            curOrders.Comments = currentQuote.Comments;
            curOrders.OrderStatus = "New";

            curOrders.DesignerName = currentQuote.DesignerName;
            curOrders.DesignerRemarks = currentQuote.DesignerRemarks;

            foreach (QuotationsDetails quoteDetails in currentQuote.QuotationsDetailsList)
            {
                OrdersDetails ordDet = new OrdersDetails();

                ordDet.ProductID = quoteDetails.ProductID;
                ordDet.ProductName = quoteDetails.ProductName;
                ordDet.UnitPrice = quoteDetails.UnitPrice;
                ordDet.OrderPrice = quoteDetails.OrderPrice;
                ordDet.Quantity = quoteDetails.Quantity;
                ordDet.Amount = quoteDetails.Amount;
                ordDet.SpecialInstruction = quoteDetails.SpecialInstruction;
                ordDet.CanApplyDiscount = quoteDetails.CanApplyDiscount;
                ordDet.Remarks = quoteDetails.Remarks;
                ordDet.IsMiscellaneous = quoteDetails.IsMiscellaneous;
                ordDet.OrderStatus = "New";

                ordDet.DiscountType = string.Empty;
                ordDet.DiscountValue = 0.00M;

                curOrders.OrdersDetailsList.Add(ordDet);
            }
            curOrders.QuotationReferenceID = currentQuote.UniqueID;

            AppSession.CurrentUser = (curOrders.UsersAccountID != null && curOrders.UsersAccountID != Guid.Empty ? UserAccountBL.GetItem(curOrders.UsersAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue) : null);
            return curOrders;
        }

        private void TextBlock_MouseUp(object sender, MouseButtonEventArgs e)
        {
            TextBlock SelectedTransaction = sender as TextBlock;
            DataGridRow dgr = GetParent(SelectedTransaction);
            Quotations currentQuote = dgr.DataContext as Quotations;
            AppSession.CurrentOrders = ConvertQuoteToPayment(currentQuote);
            MasterWindow Master = new MasterWindow();
            Master.LoadPages(new Ordering(), Menus.ORDER);
        }

        private void LoadPendingQuotations(string SearchKey, DateTime StartDate, DateTime EndDate, char OrderFromFlag)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                List<Quotations> pcList = QuotationsBL.GetList(Guid.Empty, SearchKey, StartDate, EndDate);
                string OrderedFrom = OrderFromFlag == 'A' ? "All" : (OrderFromFlag == 'P' ? "POS" : "Web");
                //Select Only Pending Orders and Selected Order Source - POS, Web or Both
                if (OrderedFrom != "All")
                    pcList = (from pl in pcList
                              orderby pl.QuotationsNumber descending
                              where (pl.QuotationsStatus.ToLower() == "pending" || pl.QuotationsStatus.ToLower() == "new"
                              && pl.OrderFrom == OrderedFrom)
                              select pl).ToList<Quotations>();
                else
                    pcList = (from pl in pcList
                              orderby pl.QuotationsNumber descending
                              where pl.QuotationsStatus.ToLower() == "pending" || pl.QuotationsStatus.ToLower() == "new"
                              select pl).ToList<Quotations>();

                gvPendingQuotation.Dispatcher.BeginInvoke(new Action(() => gvPendingQuotation.ItemsSource = pcList));
            });
        }

        private void chk_Checked(object sender, RoutedEventArgs e)
        {
            if (((sender) as CheckBox).Name == chkPOS.Name)
            {
                chkWeb.IsChecked = false;
            }
            else
            {
                chkPOS.IsChecked = false;
            }
        }

        private DataGridRow GetParent(DependencyObject dep)
        {
            DependencyObject Obj = null;
            if (dep.GetType() == typeof(DataGridRow))
            {
                Obj = dep as DataGridRow;
            }
            else
            {
                Obj = GetParent(VisualTreeHelper.GetParent(dep));
            }
            return Obj as DataGridRow;
        }
    }
}
